#!/bin/bash
Ver=1.06
pakage_name=$1
POST_sh=post-install.sh
#ROOT_MARK=""; [ "$(id -u)" == "0" ] || ROOT_MARK="#";

if [ $# -lt 4 ]
then
cat <<HELP
Self - Executable Installer Creator ver.$Ver
by Krzysztof Żurek (c) 2020 - `date +%Y`
The program is free for non-commercial use!
For more info go to https://zurek.xyz/projects/seicreator

Usage:
$(basename ${0}) <installer_name> <target_directory> <components_to_package ...>
HELP
exit 1
fi

shift
w_dir="$1"
shift
components="$@"
tmpfile=$(mktemp ./seitmp.XXXXXX)
cat > $tmpfile <<SCRIPT_TOP
#!/bin/bash
#Self - Executable Installer version $Ver (C) 2020 - `date +%Y` All Rights Reserved!
#HASH

die() { echo "Error! Access is missing or the file is corrupt!"; echo -en '\a'; exit 1; }
[ \${#} -gt 0 ] && [ "\$1" == "-h" ] && { head -n 2 "\$0" | tail -n 1 | cut -d'#' -f2-; echo Usage: \${0}[ /install/dir]; exit 0; }
[ \${#} -gt 0 ] && [ -d "\${1}" ] && w_dir="\${1}" || w_dir="$w_dir"

PEWUDE="\$PWD"
############################################################################################H
cd "\$w_dir" > /dev/null 2>&1 || die

head -n 2 \${PEWUDE}/\$(basename "\$0") | tail -n 1 | cut -d'#' -f2- 2>/dev/null

echo "Copying files ..."

sign=\$((\`grep -an "^TGZ_MARKER$" "\$PEWUDE/\$0" | cut -d: -f1\` + 1))
tail -n+\${sign} "\$PEWUDE/\$0" | tar zxf - 2>/dev/null || die

[ -x ./${POST_sh} ] && ./${POST_sh} "\$w_dir" $components

cd \$PEWUDE

#echo "done"

sleep 3 && rm -f "\$0"

exit
TGZ_MARKER
SCRIPT_TOP
tar zcf - ${components} >> $tmpfile

chmod u+w ${pakage_name} > /dev/null 2>&1

head -n 2 $tmpfile > ${pakage_name}

echo -n '#HASH' >> ${pakage_name}
grep -av '^#HASH' $tmpfile | md5sum | cut -d" " -f1 >> ${pakage_name}

sign=$((`grep -an "^#HASH" $tmpfile | cut -d: -f1` + 1))
tail -n+${sign} $tmpfile >> ${pakage_name}

chmod 555 ${pakage_name}

rm -f $tmpfile

exit

